<?php

namespace App\View\Components;

use Illuminate\View\Component;

class BBCodeEditor extends Component
{
    public $name;
    public $placeholder;
    public $content;
    public $height;

    /**
     * Create a new component instance.
     *
     * @return void
     */
    public function __construct(
        $name = 'content',
        $placeholder = 'Write your reply here...',
        $content = '',
        $height = '200px'
    ) {
        $this->name = $name;
        $this->placeholder = $placeholder;
        $this->content = $content;
        $this->height = $height;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {
        return view('components.bbcode-editor');
    }
}